using System;
using System.Data;
using System.Data.SqlTypes;
using System.Data.SqlClient;
using STOREDPROC = gov.va.med.vbecs.Common.VbecsStoredProcs;

namespace gov.va.med.vbecs.DAL
{
	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Carl Jensen</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>08/25/2004</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	/// IssueReturnReport data access layer class.
	///</summary>

	#endregion
	
	public class IssueReturnReport
	{
		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5513"> 
		///		<ExpectedInput>Date range that will return records</ExpectedInput>
		///		<ExpectedOutput>A count of at least 1</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5514"> 
		///		<ExpectedInput>Future date range</ExpectedInput>
		///		<ExpectedOutput>A count of 0</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// GetIssueReturnReportCount
		/// </summary>
		/// <returns></returns>
		public static int GetIssueReturnReportCount(DateTime startDate, DateTime endDate, string divisionCode)
		{
			int count = 0;
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetReportIssuedReturnedUnitCount.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportIssuedReturnedUnitCount.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportIssuedReturnedUnitCount.divisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetReportIssuedReturnedUnitCount.StoredProcName, prms).Tables[0];
			
			foreach(DataRow dr in dt.Rows)
			{
				count += (int)dr["Total"];
			}
			
			return count;
		}

		///<Developers>
		///	<Developer>C. Jensen</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/30/2004</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="5515"> 
		///		<ExpectedInput>Date range that will return records</ExpectedInput>
		///		<ExpectedOutput>At least 1 record</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="5516"> 
		///		<ExpectedInput>Future date range</ExpectedInput>
		///		<ExpectedOutput>No records</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a DataTable representing the issue/return report
		/// </summary>
		/// <returns></returns>
		public static DataTable GetIssueReturnReport(DateTime startDate, DateTime endDate, string divisionCode)
		{
			SqlParameter [] prms = 
			{
				new SqlParameter(STOREDPROC.GetReportIssuedReturnedUnit.startdate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportIssuedReturnedUnit.enddate, System.Data.SqlDbType.DateTime),
				new SqlParameter(STOREDPROC.GetReportIssuedReturnedUnit.divisionCode, System.Data.SqlDbType.Char)
			};
			prms[0].Value = startDate;
			prms[1].Value = endDate;
			prms[2].Value = divisionCode;

			DataTable dt = Common.StoredProcedure.GetData(STOREDPROC.GetReportIssuedReturnedUnit.StoredProcName, prms).Tables[0];
			dt.TableName = "IssueReturnReport";
			return dt;
		}
	}
}
